/*************************************************************************/
/*    Copyright (C) 2017 Wizardry and Steamworks - License: GNU GPLv3    */
/*************************************************************************/
/* fuss/lambda_calculus/functional_programming/aggregators @ grimore.org */
/*************************************************************************/
function wasSwitch() {
    if(arguments.length % 2 !== 0) {
        throw "Pairs of predicates expected for cases";
    }
    
    (Array.isArray(arguments[0]) ? arguments[0] : [ arguments[0] ]).forEach(function(s) {
        var m = false;
        for(var i = 2; i < arguments.length; i += 2) {
            if(!arguments[i](s)) {
                continue;
            }
            if(!arguments[i + 1](s)) {
                continue;
            }
            m = true;
        }
    
        if(!m) {
            arguments[1](s);
        }
    });
}
if (!Array.prototype.switch) {
    Array.prototype.switch = function() {
        wasSwitch(this, arguments[0], arguments.slice(1));
    };
}
// jQuery
if(typeof jQuery === 'function') {
    $.extend({
        switch: wasSwitch
    });
}

/*************************************************************************/
/* Node.JS package export.                                               */
/*************************************************************************/
if(typeof module !== 'undefined' && typeof module.exports !== 'undefined') {
    module.exports.lambda = {
        switch: wasSwitch
    };
}
