# plugin-error [![NPM version](https://badge.fury.io/js/plugin-error.svg)](http://badge.fury.io/js/plugin-error)  [![Build Status](https://travis-ci.org/jonschlinkert/plugin-error.svg)](https://travis-ci.org/jonschlinkert/plugin-error)

> Error handling for vinyl plugins. Just an abstraction of what's in gulp-util with minor changes.

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i plugin-error --save
```

## Usage

```js
var PluginError = require('plugin-error');
```

### new PluginError(pluginName, message[, options]);

**Params**

* `pluginName` should be the module name of your plugin
* `message` **{String|Object}**: may be a string or an existing error object
* `options` **{Object}**

**Behavior:**

* By default the stack will not be shown. Set `options.showStack` to true if you think the stack is important for your error.
* If you pass an error object as the message the stack will be pulled from that, otherwise one will be created.
* If you pass in a custom stack string you need to include the message along with that.
* Error properties will be included in `err.toString()`, but may be omitted by including `{showProperties: false}` in the options.

**Examples**

All of the following are acceptable forms of instantiation:

```javascript
var err = new PluginError('test', {
  message: 'something broke'
});

var err = new PluginError({
  plugin: 'test',
  message: 'something broke'
});

var err = new PluginError('test', 'something broke');

var err = new PluginError('test', 'something broke', {showStack: true});

var existingError = new Error('OMG');
var err = new PluginError('test', existingError, {showStack: true});
```

## Related projects

* [assemble](http://assemble.io): Static site generator for Grunt.js, Yeoman and Node.js. Used by Zurb Foundation, Zurb Ink, H5BP/Effeckt,… [more](http://assemble.io)
* [gulp-util](https://github.com/wearefractal/gulp-util#readme): Utility functions for gulp plugins
* [gulp](http://gulpjs.com): The streaming build system
* [generate](https://github.com/generate/generate): Project generator, for node.js.
* [verb](https://github.com/assemble/verb): Documentation generator for GitHub projects. Extremely powerful, easy to use, can generate anything from API… [more](https://github.com/assemble/verb)

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/plugin-error/issues/new)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on May 31, 2015._
