@echo off
rem ------------------------------------------------------------------------------------------------
rem -- This script can be used to install Corrade as a Windows service via NSSM (https://nssm.cc) --
rem -- The CONFIGURATION section may be adapted to change various parameters used by the script.  --
rem --                                                                                            --
rem -- Kudos to Ian Patterson for NSSM which is a public domain tool.                             --
rem ------------------------------------------------------------------------------------------------

rem ------------------------------------------------------------------------------------------------
rem --                                  CONFIGURATION                                             --
rem ------------------------------------------------------------------------------------------------

rem -- Set this to the name of the Corrade service (default: Corrade Resident).
rem -- Tip: name folders, service names and other identifiers by the avatar name that the bot
rem -- connects to in order to make debugging easier when something goes wrong.
set "_serviceName=Corrade Resident"

rem ------------------------------------------------------------------------------------------------
rem --                                    INTERNALS                                               --
rem ------------------------------------------------------------------------------------------------

rem ------------------------------------------------------------------------------------------------
rem --   elevate privileges see "https://stackoverflow.com/a/12264592/1016343" for description    --
rem ------------------------------------------------------------------------------------------------

:init
 setlocal DisableDelayedExpansion
 set cmdInvoke=1
 set winSysFolder=System32
 set "batchPath=%~0"
 for %%k in (%0) do set batchName=%%~nk
 set "vbsGetPrivileges=%temp%\OEgetPriv_%batchName%.vbs"
 setlocal EnableDelayedExpansion

:checkPrivileges
  NET FILE 1>NUL 2>NUL
  if '%errorlevel%' == '0' ( goto gotPrivileges ) else ( goto getPrivileges )

:getPrivileges
  if '%1'=='ELEV' (echo ELEV & shift /1 & goto gotPrivileges)

  ECHO Set UAC = CreateObject^("Shell.Application"^) > "%vbsGetPrivileges%"
  ECHO args = "ELEV " >> "%vbsGetPrivileges%"
  ECHO For Each strArg in WScript.Arguments >> "%vbsGetPrivileges%"
  ECHO args = args ^& strArg ^& " "  >> "%vbsGetPrivileges%"
  ECHO Next >> "%vbsGetPrivileges%"

  if '%cmdInvoke%'=='1' goto InvokeCmd 

  ECHO UAC.ShellExecute "!batchPath!", args, "", "runas", 1 >> "%vbsGetPrivileges%"
  goto ExecElevation

:InvokeCmd
  ECHO args = "/c """ + "!batchPath!" + """ " + args >> "%vbsGetPrivileges%"
  ECHO UAC.ShellExecute "%SystemRoot%\%winSysFolder%\cmd.exe", args, "", "runas", 1 >> "%vbsGetPrivileges%"

:ExecElevation
 "%SystemRoot%\%winSysFolder%\WScript.exe" "%vbsGetPrivileges%" %*
 exit /B

:gotPrivileges
 setlocal & cd /d %~dp0
 if '%1'=='ELEV' (del "%vbsGetPrivileges%" 1>nul 2>nul  &  shift /1)

rem ------------------------------------------------------------------------------------------------
rem -- Start Corrade service install script.                                                      --
rem ------------------------------------------------------------------------------------------------

set "_corrade=Corrade.exe"
set "_path=%CD%"
echo "%_serviceName%"

for %%a in ("%_path%") do set "contrib=%%~dpa"
for %%a in ("%contrib:~0,-1%") do set "workDir=%%~dpa"

call set "exePath=%workDir%%_corrade%"

set "dir=%workDir%"
set "exe=%exePath%"

nssm install "%_serviceName%" "%exe%"
nssm set "%_serviceName%" Description "The libOpenMetaverse scripted agent" > nul
nssm set "%_serviceName%" Start "SERVICE_AUTO_START" > nul
nssm set "%_serviceName%" ObjectName "LocalSystem" > nul
nssm set "%_serviceName%" AppThrottle 1500 > nul
nssm set "%_serviceName%" AppExit Default Restart > nul
nssm set "%_serviceName%" AppRestartDelay 1000 > nul
nssm set "%_serviceName%" AppDirectory %dir% > nul
nssm set "%_serviceName%" DisplayName %_serviceName% > nul

pause
