/*************************************************************************/
/*    Copyright (C) 2017 Wizardry and Steamworks - License: GNU GPLv3    */
/*************************************************************************/
function wasProduct(a, b) {
    var m = Math.max(a.length, b.length);
    var o = {};
    for(var i = 0; i < m; ++i) {
        o[a[i]] = b[i];
    }
    return o;
}
if (!Array.prototype.product) {
    Array.prototype.product = function(b) {
        return wasProduct(this, b);
    };
}
// jQuery
if(typeof jQuery === 'function') {
    $.extend({
        product: wasProduct
    });
}

/*************************************************************************/
/*    Copyright (C) 2017 Wizardry and Steamworks - License: GNU GPLv3    */
/*************************************************************************/
function wasStride(a, s) {
    return a.filter(function(e, i) {
        return i % s === 0;
    });
}
if (!Array.prototype.stride) {
    Array.prototype.stride = function(s) {
        return wasStride(this, s);
    };
}
// jQuery
if(typeof jQuery === 'function') {
    $.extend({
        stride: wasStride
    });
}

/*************************************************************************/
/*    Copyright (C) 2017 Wizardry and Steamworks - License: GNU GPLv3    */
/*************************************************************************/
// Vanilla JavaScript
function wasChunk(a, n) {
    if (!a.length) {
        return [];
    }
    return [a.slice(0, n)]
        .concat(a.slice(n).wasChunk(n));
}
if (!Array.prototype.chunk) {
    Array.prototype.chunk = function(a, n) {
        return wasChunk(this, n);
    };
}
// jQuery
if(typeof jQuery === 'function') {
    $.extend({
        chunk: wasChunk
    });
}

/*************************************************************************/
/*    Copyright (C) 2017 Wizardry and Steamworks - License: GNU GPLv3    */
/*************************************************************************/
/*stackoverflow.com/questions/7837456/how-to-compare-arrays-in-javascript*/
/*************************************************************************/
// Vanilla JavaScript
function wasEquals(a, b) {
    // if the other array is a falsy value, return
    if (!b) {
        return false;
    }

    // compare lengths - can save a lot of time 
    if (a.length !== b.length) {
        return false;
    }

    for (var i = 0, l = a.length; i < l; i++) {
        // Check if we have nested arrays
        if (a[i] instanceof Array && b[i] instanceof Array) {
            // recurse into the nested arrays
            if (!a[i].equals(b[i])) {
                return false;
            }
        } else if (a[i] !== b[i]) {
            // Warning - two different object instances will never be equal: {x:20} != {x:20}
            return false;
        }
    }
    return true;
}
if (!Array.prototype.equals) {
    // attach the .equals method to Array's prototype to call it on any array
    Array.prototype.equals = function(a, b) {
        return wasEquals(this, b);
    };
}
// jQuery
if(typeof jQuery === 'function') {
    $.extend({
        equals: wasEquals
    });
}

/*************************************************************************/
/* Node.JS package export.                                               */
/*************************************************************************/
if(typeof module !== 'undefined' && typeof module.exports !== 'undefined') {
    module.exports.collections = {
        product: wasProduct,
        stride: wasStride,
        chunk: wasChunk,
        equals: wasEquals
    };
}
