/*************************************************************************/
/*    Copyright (C) 2015 Wizardry and Steamworks - License: GNU GPLv3    */
/*************************************************************************/
function wasMapValueToRange(value, xMin, xMax, yMin, yMax) {
    return yMin + (
        ( yMax - yMin ) * ( value - xMin ) / ( xMax - xMin )
    );
}

/*************************************************************************/
/* Node.JS package export.                                               */
/*************************************************************************/
if(typeof module !== 'undefined' && typeof module.exports !== 'undefined') {
    module.exports.mathematics = {
        MapValueToRange: wasMapValueToRange
    };
}
