# Popular Extensions

Many extensions can be found on the [Chart.js GitHub organization](https://github.com/chartjs) or on the [npm registry](https://www.npmjs.com/search?q=chartjs-).

## Charts

 - <a href="https://github.com/chartjs/chartjs-chart-financial" target="_blank">chartjs-chart-financial</a> - Adds financial chart types such as a candlestick.
 - <a href="https://github.com/chartjs/Chart.BarFunnel.js" target="_blank">Chart.BarFunnel.js</a> - Adds a bar funnel chart type.
 - <a href="https://github.com/chartjs/Chart.LinearGauge.js" target="_blank">Chart.LinearGauge.js</a> - Adds a linear gauge chart type.
 - <a href="https://github.com/chartjs/Chart.smith.js" target="_blank">Chart.Smith.js</a> - Adds a smith chart type.

In addition, many charts can be found on the [npm registry](https://www.npmjs.com/search?q=chartjs-chart-).

## Plugins

 - <a href="https://github.com/chartjs/chartjs-plugin-annotation" target="_blank">chartjs-plugin-annotation</a> - Draws lines and boxes on chart area.
 - <a href="https://github.com/chartjs/chartjs-plugin-datalabels" target="_blank">chartjs-plugin-datalabels</a> - Displays labels on data for any type of charts.
 - <a href="https://github.com/chartjs/chartjs-plugin-deferred" target="_blank">chartjs-plugin-deferred</a> - Defers initial chart update until chart scrolls into viewport.
 - <a href="https://github.com/compwright/chartjs-plugin-draggable" target="_blank">chartjs-plugin-draggable</a> - Makes select chart elements draggable with the mouse.
 - <a href="https://github.com/y-takey/chartjs-plugin-stacked100" target="_blank">chartjs-plugin-stacked100</a> - Draws 100% stacked bar chart.
 - <a href="https://github.com/everestate/chartjs-plugin-waterfall" target="_blank">chartjs-plugin-waterfall</a> - Enables easy use of waterfall charts.
 - <a href="https://github.com/chartjs/chartjs-plugin-zoom" target="_blank">chartjs-plugin-zoom</a> - Enables zooming and panning on charts.

In addition, many plugins can be found on the [npm registry](https://www.npmjs.com/search?q=chartjs-plugin-).

## Integrations

### Angular (v2+)

 - <a href="https://github.com/emn178/angular2-chartjs" target="_blank">emn178/angular2-chartjs</a>
 - <a href="https://github.com/valor-software/ng2-charts" target="_blank">valor-software/ng2-charts</a>

### Angular (v1)
 - <a href="https://github.com/jtblin/angular-chart.js" target="_blank">angular-chart.js</a>
 - <a href="https://github.com/carlcraig/tc-angular-chartjs" target="_blank">tc-angular-chartjs</a>
 - <a href="https://github.com/petermelias/angular-chartjs" target="_blank">angular-chartjs</a>
 - <a href="https://github.com/earlonrails/angular-chartjs-directive" target="_blank">Angular Chart-js Directive</a>

### React
 - <a href="https://github.com/topdmc/react-chartjs2" target="_blank">react-chartjs2</a>
 - <a href="https://github.com/gor181/react-chartjs-2" target="_blank">react-chartjs-2</a>

### Django
 - <a href="https://github.com/matthisk/django-jchart" target="_blank">Django JChart</a>
 - <a href="https://github.com/novafloss/django-chartjs" target="_blank">Django Chartjs</a>

### Ruby on Rails
 - <a href="https://github.com/airblade/chartjs-ror" target="_blank">chartjs-ror</a>

### Laravel
 - <a href="https://github.com/fxcosta/laravel-chartjs" target="_blank">laravel-chartjs</a>

### Vue.js
 - <a href="https://github.com/apertureless/vue-chartjs/" target="_blank">vue-chartjs</a>

### Java
 - <a href="https://github.com/mdewilde/chart/" target="_blank">Chart.java</a>

### GWT (Google Web toolkit)
 - <a href="https://github.com/pepstock-org/Charba" target="_blank">Charba</a>

### Ember.js
 - <a href="https://github.com/aomran/ember-cli-chart" target="_blank">ember-cli-chart</a>
