# default-compare [![NPM version](https://img.shields.io/npm/v/default-compare.svg?style=flat)](https://www.npmjs.com/package/default-compare) [![NPM monthly downloads](https://img.shields.io/npm/dm/default-compare.svg?style=flat)](https://npmjs.org/package/default-compare)  [![NPM total downloads](https://img.shields.io/npm/dt/default-compare.svg?style=flat)](https://npmjs.org/package/default-compare) [![Linux Build Status](https://img.shields.io/travis/doowb/default-compare.svg?style=flat&label=Travis)](https://travis-ci.org/doowb/default-compare) [![Windows Build Status](https://img.shields.io/appveyor/ci/doowb/default-compare.svg?style=flat&label=AppVeyor)](https://ci.appveyor.com/project/doowb/default-compare)

> Basic sort algorithm that has similar behavior to Array.prototype.sort for null and undefined, but also allows sorting by an object property.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save default-compare
```

Install with [yarn](https://yarnpkg.com):

```sh
$ yarn add default-compare
```

## Usage

```js
var defaultCompare = require('default-compare');
```

**basic array**

```js
var arr = ['c', 'a', undefined, 'b', 'd', null, 'e'];
console.log(arr.sort(defaultCompare));
//=> ['a', 'b', 'c', 'd', 'e', null, undefined]
```

**objects sorted by their "name" property**

```js
var arr = [
  {name: 'c', title: 'C'},
  {name: 'a', title: 'A'},
  {title: 'G'},
  {name: 'b', title: 'B'},
  {name: 'd', title: 'D'},
  {name: null, title: 'F'},
  {name: 'e', title: 'E'}
];

arr.sort(function(a, b) {
  return defaultCompare(a, b, 'name');
});

console.log(arr);
//=> [
//=>   {name: 'a', title: 'A'},
//=>   {name: 'b', title: 'B'},
//=>   {name: 'c', title: 'C'},
//=>   {name: 'd', title: 'D'},
//=>   {name: 'e', title: 'E'},
//=>   {name: null, title: 'F'},
//=>   {title: 'G'}
//=> ];
```

## API

### [defaultCompare](index.js#L16)

Basic sort algorithm that has similar behavior to `Array.prototype.sort`
for null and undefined, but also allows sorting by an object property.

**Params**

* `a` **{Mixed}**: First value to compare.
* `b` **{Mixed}**: Second value to compare.
* `prop` **{String}**: Optional property to use when comparing objects. If specified must be a string.
* `returns` **{Number}**: Returns 1 when `a` should come after `b`, -1 when `a` should come before `b`, and 0 when `a` and `b` are equal.

## About

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

Please read the [contributing guide](.github/contributing.md) for advice on opening issues, pull requests, and coding standards.

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Brian Woodward**

* [github/doowb](https://github.com/doowb)
* [twitter/doowb](https://twitter.com/doowb)

### License

Copyright © 2017, [Brian Woodward](https://doowb.com).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on September 11, 2017._