/*************************************************************************/
/*    Copyright (C) 2015 Wizardry and Steamworks - License: GNU GPLv3    */
/*************************************************************************/
function wasHexToRGB(hex) {
    var shortRegEx = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
    hex = hex.replace(
        shortRegEx,
        function(m, r, g, b) {
            return r + r + g + g + b + b;
        }
    );

    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result ? {
        r: parseInt(result[1], 16),
        g: parseInt(result[2], 16),
        b: parseInt(result[3], 16)
    } : null;
}

/*************************************************************************/
/*    Copyright (C) 2015 Wizardry and Steamworks - License: GNU GPLv3    */
/*************************************************************************/
function wasRGBToHex(r, g, b) {
    return "#" + (
        (1 << 24) +
        (r << 16) +
        (g << 8) +
        b
    ).toString(16).slice(1);
}

/*************************************************************************/
/* Node.JS package export.                                               */
/*************************************************************************/
if(typeof module !== 'undefined' && typeof module.exports !== 'undefined') {
    module.exports.physics = {
        HexToRGB: wasHexToRGB,
        RGBToHex: wasRGBToHex
    };
}
